﻿Option Strict On
Option Explicit On
Option Infer On

Public Class Form1

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        'TODO: This line of code loads data into the 'TelefonyDataSet.ListaOsob' table. You can move, or remove it, as needed.
        Me.ListaOsobTableAdapter.Fill(Me.TelefonyDataSet.ListaOsob)

    End Sub

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        'tam
        Dim listaOsobPelnoletnich = From osoba In TelefonyDataSet.ListaOsob
                                    Where osoba.Wiek >= 18
                                    Order By osoba.Nazwisko, osoba.Imię
                                    Select osoba

        'z powrotem
        Dim dt As DataTable = listaOsobPelnoletnich.CopyToDataTable()
        dt.TableName = "ListaOsobPelnoletnich"

        Dim s As String = "Kolumny tabeli:" & vbNewLine
        For Each kolumna In dt.Columns
            s += kolumna.ToString() & vbNewLine
        Next
        MessageBox.Show(s)

        TelefonyDataSet.Tables.Add(dt)

        s = "Nazwy tabel:" & vbNewLine
        For Each tabela In TelefonyDataSet.Tables
            s += tabela.ToString() & vbNewLine
        Next
        MessageBox.Show(s)

        TelefonyDataSetBindingSource.DataMember = dt.TableName
    End Sub

    Class Osoba
        Public Id As Integer
        Public Imię, Nazwisko As String
        Public NumerTelefonu As Integer
        Public Wiek As Integer
    End Class

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        'tam
        Dim listaOsobPelnoletnich = From osoba In TelefonyDataSet.ListaOsob
                                    Where osoba.Wiek >= 18
                                    Order By osoba.Nazwisko, osoba.Imię
                                    Select New Osoba With {.Id = osoba.Id, .Imię = osoba.Imię, .Nazwisko = osoba.Nazwisko, .NumerTelefonu = osoba.NumerTelefonu, .Wiek = osoba.Wiek}

        'Dim s1 As String = "Lista osób pełnoletnich:" & vbNewLine
        'For Each osoba In listaOsobPelnoletnich
        '    s1 += osoba.Imię & " " & osoba.Nazwisko & vbNewLine
        'Next
        'MessageBox.Show(s1)

        'z powrotem - "ręczne" projektowanie tabeli
        Dim dt As DataTable = New DataTable("ListaOsobPelnoletnich")

        Dim first As Osoba = listaOsobPelnoletnich.First()
        Dim dcId As DataColumn = New DataColumn("Id")
        dcId.AllowDBNull = False
        dcId.DataType = first.Id.GetType()
        Dim dcImię As DataColumn = New DataColumn("Imię")
        dcImię.DataType = first.Imię.GetType()
        Dim dcNazwisko As DataColumn = New DataColumn("Nazwisko")
        dcNazwisko.DataType = first.Nazwisko.GetType()
        Dim dcNumerTelefonu As DataColumn = New DataColumn("NumerTelefonu")
        dcNumerTelefonu.DataType = first.NumerTelefonu.GetType()
        Dim dcWiek As DataColumn = New DataColumn("Wiek")
        dcWiek.DataType = first.Wiek.GetType()

        dt.Columns.Add(dcId)
        dt.Columns.Add(dcImię)
        dt.Columns.Add(dcNazwisko)
        dt.Columns.Add(dcNumerTelefonu)
        dt.Columns.Add(dcWiek)

        'zapełnianie tabeli danymi
        For Each osoba As Osoba In listaOsobPelnoletnich
            Dim dr As DataRow = dt.NewRow()
            dr("Id") = osoba.Id
            dr("Imię") = osoba.Imię
            dr("Nazwisko") = osoba.Nazwisko
            dr("NumerTelefonu") = osoba.NumerTelefonu
            dr("Wiek") = osoba.Wiek
            dt.Rows.Add(dr)
        Next

        Dim s As String = "Kolumny tabeli:" & vbNewLine
        For Each kolumna In dt.Columns
            s += kolumna.ToString() & vbNewLine
        Next
        MessageBox.Show(s)

        TelefonyDataSet.Tables.Add(dt)

        s = "Nazwy tabel:" & vbNewLine
        For Each tabela In TelefonyDataSet.Tables
            s += tabela.ToString() & vbNewLine
        Next
        MessageBox.Show(s)

        TelefonyDataSetBindingSource.DataMember = dt.TableName

    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        Dim dt As DataTable = TelefonyDataSet.ListaOsob
        Dim iloscOsobPelnoletnich As Integer = dt.AsEnumerable().Count(Function(dr) dr.Field(Of Integer)("Wiek") > 18)
        MessageBox.Show("Ilość osób pełnoletnich: " & iloscOsobPelnoletnich.ToString())

        Dim sredniWiek As Double = dt.AsEnumerable().Average(Function(osoba) osoba.Field(Of Integer)("Wiek"))
        MessageBox.Show("Średni wiek: " & sredniWiek.ToString())
    End Sub

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        Dim listaKobiet = From osoba In TelefonyDataSet.ListaOsob
                  Where osoba.Imię.EndsWith("a")
                  Order By -osoba.Nazwisko.Length
                  Select New With {.Id = osoba.Id,
                                   .Imię = osoba.Imię,
                                   .Nazwisko = osoba.Nazwisko,
                                   .NumerTelefonu = osoba.NumerTelefonu,
                                   .Wiek = osoba.Wiek}

        Dim s As String = "Lista kobiet:" & vbNewLine
        For Each osoba In listaKobiet
            s += osoba.Imię & " " & osoba.Nazwisko & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button5_Click(sender As System.Object, e As System.EventArgs) Handles Button5.Click
        Dim xml As XDocument = New XDocument(
            New XDeclaration("1.0", "utf-8", "yes"),
            New XElement("ListaOsob",
                From osoba In TelefonyDataSet.ListaOsob
                Order By osoba.Wiek
                Select New XElement("Osoba",
                    New XAttribute("Id", osoba.Id),
                    New XElement("Imię", osoba.Imię),
                    New XElement("Nazwisko", osoba.Nazwisko),
                    New XElement("NumerTelefonu", osoba.NumerTelefonu),
                    New XElement("Wiek", osoba.Wiek)
                )
            )
        )

        xml.Save("ListaOsob.xml")
    End Sub
End Class
